/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.fabric;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.gui.screen.ItemRenameScreen;
import io.github.mortuusars.exposure.client.gui.screen.LightroomScreen;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumScreen;
import io.github.mortuusars.exposure.client.gui.screen.album.LecternAlbumScreen;
import io.github.mortuusars.exposure.client.gui.screen.camera.CameraAttachmentsScreen;
import io.github.mortuusars.exposure.client.gui.tooltip.PhotographClientTooltip;
import io.github.mortuusars.exposure.client.input.KeyboardHandler;
import io.github.mortuusars.exposure.client.render.GlassPhotographFrameEntityRenderer;
import io.github.mortuusars.exposure.client.render.PhotographFrameEntityRenderer;
import io.github.mortuusars.exposure.fabric.resources.ExposureFabricClientReloadListener;
import io.github.mortuusars.exposure.integration.ModCompatibilityClient;
import io.github.mortuusars.exposure.network.fabric.FabricS2CPacketHandler;
import io.github.mortuusars.exposure.world.inventory.tooltip.PhotographTooltip;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3929;

public class ExposureFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ExposureClient.init();
        KeyboardHandler.registerKeymappings(KeyBindingHelper::registerKeyBinding);
        class_3929.method_17542(Exposure.MenuTypes.CAMERA.get(), CameraAttachmentsScreen::new);
        class_3929.method_17542(Exposure.MenuTypes.ALBUM.get(), AlbumScreen::new);
        class_3929.method_17542(Exposure.MenuTypes.LECTERN_ALBUM.get(), LecternAlbumScreen::new);
        class_3929.method_17542(Exposure.MenuTypes.LIGHTROOM.get(), LightroomScreen::new);
        class_3929.method_17542(Exposure.MenuTypes.ITEM_RENAME.get(), ItemRenameScreen::new);
        ModelLoadingPlugin.register(pluginContext -> pluginContext.addModels(new class_2960[]{ExposureClient.Models.CAMERA_GUI.comp_2875(), ExposureClient.Models.PHOTOGRAPH_FRAME_SMALL.comp_2875(), ExposureClient.Models.PHOTOGRAPH_FRAME_MEDIUM.comp_2875(), ExposureClient.Models.PHOTOGRAPH_FRAME_LARGE.comp_2875(), ExposureClient.Models.CLEAR_PHOTOGRAPH_FRAME_SMALL.comp_2875(), ExposureClient.Models.CLEAR_PHOTOGRAPH_FRAME_MEDIUM.comp_2875(), ExposureClient.Models.CLEAR_PHOTOGRAPH_FRAME_LARGE.comp_2875()}));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ExposureFabricClientReloadListener());
        EntityRendererRegistry.register(Exposure.EntityTypes.PHOTOGRAPH_FRAME.get(), PhotographFrameEntityRenderer::new);
        EntityRendererRegistry.register(Exposure.EntityTypes.CLEAR_PHOTOGRAPH_FRAME.get(), GlassPhotographFrameEntityRenderer::new);
        TooltipComponentCallback.EVENT.register(data -> {
            PhotographClientTooltip photographClientTooltip;
            if (data instanceof PhotographTooltip) {
                PhotographTooltip photographTooltip = (PhotographTooltip)data;
                photographClientTooltip = new PhotographClientTooltip(photographTooltip);
            } else {
                photographClientTooltip = null;
            }
            return photographClientTooltip;
        });
        FabricS2CPacketHandler.register();
        ModCompatibilityClient.handle();
    }
}

